function CDX = set_omega1(CDX, omega1, dates)
% --------------------------------------------------------------------------------------------------
% Set fraction of idiosyncratic and systematic jump intensities
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% omega1    ... time series of L_Y / (L_idio+L_Y)
% dates     ... dates for which to set parameters, if omega1 of length > 1
% --------------------------------------------------------------------------------------------------
% sample call: set_omega1(CDX_NA_IG, 0.5);
% --------------------------------------------------------------------------------------------------

% Get time series of total L
L_total = CDX.AJD_common_factor.L + CDX.portfolio(1).AJD.L;

% Use fixed (i.e. time-homogenous parameter)
if (nargin == 2)
    % Set value for common factor
    CDX.AJD_common_factor.L = omega1 * L_total;
    
    % Set value for individual CDS
    for i=1:length(CDX.portfolio)
        CDX.portfolio(i).AJD.L = (1 - omega1) .* L_total;
    end
    return
end

% Set value for common factor
[trash, used_pos_cdx, used_pos_params] = intersect_sorted(CDX.dates{1}, dates);
CDX.AJD_common_factor.L(used_pos_cdx,:) = omega1(used_pos_params,:) .* L_total(used_pos_cdx,:);

% Set value for individual CDS
for i=1:length(CDX.portfolio)
    % Determine matching dates
    cds = CDX.portfolio(i);
    [trash, used_pos_cdx, used_pos_cds, used_pos_params] = intersect_triple(CDX.dates{1}, cds.dates{1}, dates);
    if (length(used_pos_cds) > 0)
        cds.AJD.L(used_pos_cds,:) = (1 - omega1(used_pos_params)) .* L_total(used_pos_cdx);
        CDX.portfolio(i) = cds;
    end
    clear trash used_pos_cds used_pos_params
end